﻿#Study data verification
# read the study 2 data from a csv file
carbon2<-read.csv("carbon2.csv")


#count the number of rows (participants) in the datafile (cleaned)
nrow(carbon2)


#calculate pooled standard deviations for Democrats
pooled_demo_2 <- sqrt(((Table3$sd[1:1]^2)+(Table3$sd[4:4]^2))/2
#calculate Cohen's d for Democrats
d_demo_2 <- (Table3$mean[1:1]-Table3$mean[4:4])/pooled_demo_2


#calculate the average and stadard deviation of thoughts listed
mean(carbon2$thoughts_listed)
sd(carbon2$thoughts_listed)


#Figure 3
#create string version of framing column
carbon2$frame <- factor(carbon2$tax0off1,
        levels = c(1, 0),
        labels = c("Offset","Tax"))


carbon2$poli <- factor(carbon2$political_party,
        levels = c(-1, 0, 1),
        labels = c("Democrat", "Independent", "Republican"))


# show the variable names and the first few rows of values
head(carbon2)


#create a table showing choice for plane ticket, splite by condition (offset vs tax) and political affiliation 
Table3 <- aggregate(carbon2$product1_offtax, list(carbon2$frame,carbon2$poli),FUN=mean)
Table3_sd <- aggregate(carbon2$product1_offtax, list(carbon2$frame,carbon2$poli),FUN=sd)
Table3_length <- aggregate(carbon2$product1_offtax, list(carbon2$frame,carbon2$poli),FUN=length)
Table3 <- merge(Table3, Table3_sd)
Table3 <- merge(Table3, Table3_length)
Table3


#rename table3 variables
names(Table3) = c('Frame','poli','value','sd','length')
Table3


#create standard error for table3
Table3$se <- Table3$sd / sqrt(Table3$length)
Table3


#chubbier Figure 3
figure3 <- ggplot(data = Table3, aes(x = poli,y = value,fill = Frame)) + geom_bar(stat = "identity", position = position_dodge(),colour = "black")+scale_y_continuous(limits = c(0, 1),breaks=seq(0,1,0.1))+ylab("Proportion Choosing the Costlier Ticket")+ xlab("Political Affiliation")+ scale_fill_manual(values = c("#FFFFFF", "#808080"))+geom_errorbar(aes(ymin=value-se, ymax=value+se),width=.2,position=position_dodge(.9))+theme_bw()+theme(panel.grid=element_blank())
figure3


#Figure 4
# read the study 2 data from a csv file
carbon2<-read.csv("carbon2.csv")


#create string version of framing column
carbon2$frame <- factor(carbon2$tax0off1,
        levels = c(1, 0),
        labels = c("Offset","Tax"))


carbon2$poli <- factor(carbon2$political_party,
        levels = c(-1, 0, 1),
        labels = c("Democrat", "Independent", "Republican"))


# show the variable names and the first few rows of values
head(carbon2)


#create a table showing mean standardized median rank difference (SMRD), splite by condition (offset vs tax) and political affiliation 
Table4 <- aggregate(carbon2$SMRD, list(carbon2$frame,carbon2$poli),FUN=mean)
Table4_sd <- aggregate(carbon2$SMRD, list(carbon2$frame,carbon2$poli),FUN=sd)
Table4_length <- aggregate(carbon2$SMRD, list(carbon2$frame,carbon2$poli),FUN=length)
Table4 <- merge(Table4, Table4_sd)
Table4 <- merge(Table4, Table4_length)
Table4


#rename table4 variables
names(Table4) = c('Frame','poli','meanSMRD','sd','length')
Table4


#create standard error for table4
Table4$se <- Table4$sd / sqrt(Table4$length)
Table4


#Figure 4
figure4 <- ggplot(data = Table4, aes(x = poli,y = SMRD,fill = Frame)) + geom_bar(stat = "identity", position = position_dodge(),colour = "black")+scale_y_continuous(limits = c(-0.5, 0.5),breaks=seq(-0.5,0.5,0.1))+ylab("Mean SMRD Score")+ xlab("Political Affiliation")+ scale_fill_manual(values = c("#FFFFFF", "#808080"))+geom_errorbar(aes(ymin=meanSMRD-se, ymax=meanSMRD+se),width=.2,position=position_dodge(.9))+theme_bw()+theme(panel.grid=element_blank())
figure4


#Figure 5
# read the study 2 data from a csv file
carbon2<-read.csv("carbon2.csv")


#create string version of framing column
carbon2$frame <- factor(carbon2$tax0off1,
        levels = c(1, 0),
        labels = c("Offset","Tax"))


carbon2$poli <- factor(carbon2$political_party,
        levels = c(-1, 0, 1),
        labels = c("Democrat", "Independent", "Republican"))


#calculate the Balance of Thoughts
carbon2$Balance <- (carbon2$env_sup_thoughts - carbon2$env_opp_thoughts)


#create a table showing mean standardized median rank difference (SMRD), splite by condition (offset vs tax) and political affiliation 
Table5 <- aggregate(carbon2$Balance, list(carbon2$frame,carbon2$poli),FUN=mean)
Table5_sd <- aggregate(carbon2$Balance, list(carbon2$frame,carbon2$poli),FUN=sd)
Table5_length <- aggregate(carbon2$Balance, list(carbon2$frame,carbon2$poli),FUN=length)
Table5 <- merge(Table5, Table5_sd)
Table5 <- merge(Table5, Table5_length)
Table5


#rename table5 variables
names(Table5) = c('Frame','poli','Balance','sd','length')
Table5


#create standard error for table4
Table5$se <- Table5$sd / sqrt(Table5$length)
Table5


#Figure 5
figure5 <- ggplot(data = Table5, aes(x = poli,y = meanBalance,fill = Frame)) + geom_bar(stat = "identity", position = position_dodge(),colour = "black")+scale_y_continuous(limits = c(-2, 2),breaks=seq(-2,2,0.5))+ylab("Mean Balance of Thoughts")+ xlab("Political Affiliation")+ scale_fill_manual(values = c("#FFFFFF", "#808080"))+geom_errorbar(aes(ymin=meanBalance-se, ymax=meanBalance+se),width=.2,position=position_dodge(.9))+theme_bw()+theme(panel.grid=element_blank())
figure5


#create a new variable for SMRD scores
carbon2$SMRDnew <- c(-99)
#example of how to change a single data point for serial 13739
#carbon2[carbon2$ï..serial==13739,"SMRDnew"] <- 2


#loop through every serial ID
for (val in carbon2$ï..serial) {
#print(val)
}